
#|_________________________________________________
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2001 by Forrest W. Young
 | For further information contact the author 
 | forrest@www.visualstats.org
 | http://www.visualstats.org
 |
 | VISTA1.LSP - VISTA RUNTIME INSTALLER (FILE 2 OF 3)
 |_________________________________________________
 |#


(defun create-vista (&key (hide-vista nil) (hide-logo nil) (starter nil))
(let* ((error-return-flag t))
(setf *vista-startup-error* error-return-flag)
(send *logo* :black-on-white nil)
(unless hide-logo (send *logo* :show-logo)(send *logo* :resize))
(setf *part* "B")
(setf *knt* 0)
(when *startup-verbose* 
      ;(listeners) ;fwy 09-23-20
      (format t "~%; PART B:   CREATE VISTA")
      (show-startup "STEP B 1: Define Global Variables and Functions"))

(setf *starter* starter)
(setf *screen-size* *real-screen-size*)
(setf screen-size *screen-size*)
(setf *now-screen-size* (effective-screen-size))

(setf *desktop-container* 
      (container-window 
       :type (desktop-style)
       :size *now-screen-size* :mainwindow t 
       :show nil :local-menus t :top-most t  
       :toolwindow nil :free t :putincontainer nil
       :title "ViSta - The Visual Statistics System."))
(enable-container *desktop-container*)


(send *desktop-container* :top-most nil)
(setf *desktop-datasheet* nil)
(setf *vv* nil)
(setf *version6* t)
(setf *version7* t)
(setf *initial-datasheet* t)
(setf *free-datasheets* nil)
(setf *free-text-windows* t)
(setf *ni* t)

(defmeth *desktop-container* :close () (vista-exit))
  
(send *desktop-container* :getobjects nil)

#|_______________________________ 
 | 
 | (2) READ RUNTIME AND PHASE2 FILES
 |      the runtime files are menu files and files that depend on menus
 |      they must be read in while *desktop-container* is active
 |_______________________________ 
 |#

(when *startup-verbose* 
	(show-startup "STEP B 2: Read RunTime Files"))

(mapcar #'(lambda (file) 
            (load (strcat *runtime-dir-name* file)))
        *runtime-files*)

;phase2 updates can modify runtime file code

(when (load (strcat *default-path* "update\\phase2.lsp") :if-does-not-exist nil)
      (setf *updated* t)
      (when *verbose* (format t "; phase2 update")))


#|_______________________________ 
 | 
 | (3) SET SCREEN SIZE & LOCATION
 |      I have replaced the very old code and messy with new code
 |_______________________________ 
 |#


(when *startup-verbose* (show-startup "STEP B 3: Set Screen Size & Location"))
(setf *no-restart* nil)
(setf *current-object* nil)
(reset-screen-size)

(when *verbose* (print "RESET-SCREEN-SIZE"))

#+macintosh (setf menu-bar-height 38)
#+macintosh (setf window-decoration-width 18) 
#+macintosh (setf window-decoration-height 18) 
#-msdos     (setf msdos-fiddle 0)
#-msdos     (setf border-thickness 0)
#+msdos(setf menu-bar-height 0)
#+msdos(setf window-decoration-width 8) ;8
#+msdos(setf window-decoration-height 28);8
#+msdos(setf border-thickness 3) ;4
#+msdos(setf msdos-fiddle 15)
#+X11 (setf menu-bar-height 0)  


#+X11 (setf window-decoration-width 0)
#+X11 (setf window-decoration-height 0)

(setf *screen-size-adjustment* 0)

(when *verbose*
      (format t "(screen-size) ~d" (screen-size))
      (format t "*screen-size* ~d" *screen-size*)
      (format t " screen-size  ~d"  screen-size )
      (format t "*screen-size-adjustment* ~d" *screen-size-adjustment*)
      (when (= (sum *now-screen-size*) 0) 
            (format t "; initializing screen size"))
      (when (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*)))
            (format t "; screen size has changed")))

(unless (= 1 *run-number*)
        (when (or (= (sum *now-screen-size*) 0)
                  (/= 0 (sum (- *max-screen-size* *previous-max-screen-size*))))
              (setf *needs-desktop-resized* t)
              (setf *full-screen* t)
              (setf *screen-size* *max-screen-size*)
              (setf *now-screen-size* *max-screen-size*)
              ))

(setf screen-size  *screen-size*)


#|_______________________________ 
 |  
 | (4) make workmap
 |_______________________________ 
 |#

(when *startup-verbose* 
	(show-startup "STEP B 4: Make WorkMap"))

(make-vista-color-variables);was (default-colors)
(make-vista-color-constants)
(when *verbose* (format t "; MAKING WORKMAP"))

#+containers(when *ni* (enable-container *desktop-container*))

(setf *workmap* (workmap))
#+containers(when *ni* (disable-container))

(setf *desktop* *workmap*)
(send *workmap* :toolbar nil)
(setf *toolbox* (toolbox))
(setf *toolbar* *toolbox*)
                                           
(send *workmap* :num-data-menu-items
      (length (send (eval *data-menu*) :items))) 
(send *workmap* :num-model-menu-items
      (length (send (eval *model-menu*) :items))) 

(setf current-data nil)
(setf current-model nil)
(setf current-transf nil)
(setf current-object nil)
(setf *current-data* nil)
(setf *current-model* nil)
(setf *current-object* nil)
(setf *current-spreadplot* nil)
(setf *current-report-window* nil)
(setf *current-help-window* nil)
(setf *current-text-window* nil)
(setf *cd* nil)
(setf $ nil)  ;current-data
(setf $$ nil) ;current-model
(setf previous-data nil)
(setf *previous-data* nil)
(setf *guidemap* nil)
(setf *expertmap* nil)
(setf v-options '((0)))
 

#|_______________________________ 
 | 
 | (5) make *vista* system object 
 |_______________________________ 
 |#

(when *startup-verbose* 
	(show-startup "STEP B 5: make *vista* system object"))

(WHEN *VERBOSE* (format t "; MAKE *VISTA* SYSTEM OBJECT"))

#+containers(when *ni* (enable-container *desktop-container* ))
(setf *vista* (vista-system))
#+containers(when *ni*  (disable-container))

(WHEN *VERBOSE* (format t "; MADE SYSTEM OBJECT"))

(setf *message-window* nil)
(send *vista* :show-load-vista *xlispstat-only*)
(send *toolbar* :initialize-master-lists)

#+msdos     (send *vista* :guide-window-size '(252 280)) 
#-msdos     (send *vista* :guide-window-size '(243 280)) 
(send *vista* :guide-window-location 
      (floor (/ (- *now-screen-size* (send *vista* :guide-window-size)) 2)))
(send *vista* :expert-window-size (send *vista* :guide-window-size))
(send *vista* :expert-window-location '(100 100))




#|_______________________________
 |
 | (6) install menus 
 |_______________________________ 
 |#

(when *startup-verbose* (show-startup "STEP B 6: install menus  "))

(WHEN *VERBOSE* (show-startup "INSTALLING MENUS"))

#+macintosh (send *apple-menu* :append-items 
                  (send menu-item-proto :new "About ViSta" :action 
                        #'(lambda () (about-vista))))


(send *vista* :long-menus nil)
(send *vista* :show-long-menus nil)
(defun make-long-menus () 
  (send *vista* :show-long-menus nil)
  (send *vista* :long-menus nil))
(send *workmap* :enabled-trans-menu nil)

(setf text-top nil)
(setf win-mac nil)
#+msdos(setf text-top t)
#+msdos(setf win-mac t)

#|_______________________________
 |
 | (7) read PREFS.LSP, DESKTOP.LSP and WORKMAP.LSP files 
 |_______________________________ 
 |#
 

(when *startup-verbose* (show-startup "STEP B 7: Read Prefs, desktop and WorkMap Files"))

(WHEN *VERBOSE* (format t "; LOADING *VISTA* PREF FILES (PREFS DESKTOP WORKMAP)"))
(failsafe-load *prefs-dir-name* "prefs.lsp")
(failsafe-load *prefs-dir-name* "desktop.lsp")
(failsafe-load *prefs-dir-name* "workmap.lsp")

(setf *fake-datasheet* nil)

(when (or (= *run-number* 1)                        ;second and third conditions
          (not (not (member 'nil *seven-values*)))  ;added by fwy jan 4 2003
          (< (min *seven-values*) 0))               ;to fix certain kinds of 
      (localize-seven-values)                       ;unexpected exit conditions
      (unless (= *run-number* 1) 
              (format t "> ; Repaired Desktop Information~%"))
      )

(when *verbose* (format t "~%Just read WorkMap files & set WorkMap values") )

#|_______________________________
 |
 | (8) create about, datasheet windows
 |_______________________________ 
 |#

(when *startup-verbose* (show-startup "STEP B 8: create about, datasheet windows  "))

#+containers
(cond
 (*ni*
  (progn
   (defmeth *desktop-container* :resize ()
     (call-next-method)
     (send *vista* :desktop-size (send self :size)))

   (enable-container *desktop-container*)
   (setf *about-window* nil)
   (setf *fake-datasheet* 
         (send graph-proto :new 2 :show nil 
               :location (list 100 100) :size (list 100 100)))
   (send *fake-datasheet* :add-slot 'showing)
   (disable-container)))
  (t
   (setf *about-window* nil)
   (setf *fake-datasheet* 
         (send graph-proto :new 2 :show nil 
               :location (list 100 100) :size (list 100 100)))
   ))

(when (< (min (- *max-screen-size* *now-screen-size*)) 0) 
      (format t "; screen size adjusted for larger screen")
      (setf *screen-size* (- *max-screen-size* *screen-size-adjustment*))
      (setf screen-size *screen-size*)
      (setf *now-screen-size* *max-screen-size*)
      (send *vista* :spreadplot-sizes *max-screen-size*)
      )

(send *vista* :color-values-list 
      (list *workmap-background* *toolbar-background* 
            *data-icon-color*  *model-icon-color* 
            *tool-icon-color* *guide-icon-color* 
            *button-on-color* *button-off-color*))

(when (= *color-mode* 0)(send *vista* :turn-color-off))
(defun about-vista () (about-vista-with-logo))

#|_______________________________
 |
 | (9) configure workmap 
 |_______________________________ 
 |#

(when *startup-verbose* (show-startup "STEP B 9: Configure ToolBar  "))

(send *vista* :show-toolbar)
(send *workmap* :toolbar t)
(send *toolbar* :draw-toolbar :show t);nil ng
(send *workmap* :show-toolbar)
(send *workmap* :icon-spacing? (send *workmap* :new-icon-style?))
(send *workmap* :title "WorkMap")
(when *verbose*  (format t "; *screen-size*  ~d" *screen-size*))
(when *verbose* (print "CONFIGURED TOOLBAR"))

#|_______________________________
 |
 | (10) make desktop listener 
 |_______________________________ 
 |#

(when *startup-verbose* (show-startup "STEP B 10: Make DeskTop Listener"))




(setf *listener* nil)
(when *verbose* (format t "; MAKE DESKTOP LISTENER"))
(enable-container *desktop-container*)
(setf *listener* (send listener-proto :new :show t))
(send *listener* :add-slot 'maximized?)
(defmeth *listener* :maximized? (&optional (value nil set))
  (if set (setf (slot-value  'maximized?) value))
  (slot-value 'maximized?))
(defmeth *listener* :close ()
  (send self :pop-out nil)
  (desktop-listener))
(disable-container)

(when *verbose* (format t "; focus returned to XLispStat Listener"))
(when (> *verbosity* 1) (listeners))

#|_______________________________
 |
 | (11) read plugin loader functions
 |_______________________________ 
 |#


(when *startup-verbose* (show-startup "STEP B 11: Read Plugin Loader Functions  "))

(setf *plugins-changed* nil)
(send *workmap* :num-toolbar-buts *nmobs*)
(send *toolbar* :num-icons *nmobs*)
(mapcar #'(lambda (file) (gc) (load file))
           (sort-data (directory (strcat *plugins-dir-name* "*.lsp"))))

(unless (= (send *toolbar* :num-icons) 
           (length (send *vista* :previous-plugins)))
        (setf *plugins-changed* t))

(when (> *num-toolbar-buts-shown-at-startup* (send *workmap* :num-toolbar-buts))
      (setf *num-toolbar-buts-shown-at-startup* (send *workmap* :num-toolbar-buts)))
(when *plugins-changed* 
      (send *toolbox* :set-new-buttons-shown 
            (iseq (length (send *vista* :plugins))))
      (send *vista* :previous-plugins (send *vista* :plugins)))

(send *vista* :analysis-menu-item-titles 
(mapcar #'(lambda (item) (send item :title))
        (send *vista* :remove-dash-menu-items *analyze-menu*)))

(send *toolbar* :change-num-tools-shown *num-toolbar-buts-shown-at-startup* )
(when *verbose* (print "PLUGIN LOADERS LOADED"))
(save-plugin-settings)


#|_______________________________
 |
 | (12) create desktop 
 |_______________________________
 |#


(when *startup-verbose* (show-startup "STEP B 12: Create DeskTop  "))

(when *verbose* (print "CREATING DESKTOP"))
(send *fake-datasheet* :title "Empty DataSheet")
(send *fake-datasheet* :clear)
(send *fake-datasheet* :back-color 'white)
(setf *datasheet* *fake-datasheet*)
(send *fake-datasheet* :add-slot 'showing)
#+macintosh(send *listener* :show-window)
(send *vista* :make-watcher :show nil)
(when *verbose* (print "STARTING DESKTOP"))
(when *verbose* (print (list "*ni* " *ni*)))
;if hangs here, because *ni* is nil



(start-desktop :show (not *hide-vista*))


(when *verbose* (print "CREATED DESKTOP")(terpri))
(install-command-menu)
(send *workmap* :resize)
(when *needs-desktop-resized*
      (format t "; screen-size reset *screen-size*  ~d" *screen-size*)
      (message-dialog "Adapting to New Screen Size.")
      (refresh-desktop))
(setf screen-size *screen-size*)


#|_______________________________
 |
 | (13) Read PHASE 3 Files
 |_______________________________
 |#

(when *startup-verbose* (show-startup "STEP B 13: Read Phase 3 Update Files"))

(when (load (strcat *default-path* "update\\phase3.lsp") :if-does-not-exist nil)
      (setf *updated* t)
      (when *verbose* (format t "; Phase3 update completed")))

#|_______________________________
 |
 | (14) Configure desktop
 |_______________________________
 |#

(when *startup-verbose* (show-startup "STEP B 14: Configure DeskTop"))


#+macintosh(send *listener* :title "Listener")
#+macintosh(make-cursor 'no-action 3)
#+macintosh(make-cursor 'i-beam 1)
#+X11 (send xlisp::*fake-menu-bar* :location 1 38)
#+X11 (send xlisp::*fake-menu-bar* :size 500 27)
#+X11 (defmeth xlisp::*fake-menu-bar* :close ())
#+X11 (send *workmap* :location 1 120)
#+X11 (send *workmap* :size 500 280)
#+X11 (defmeth XLISP::*FAKE-MENU-BAR* :close () (quit))


(send *workmap* :enabled-trans-menu t)
(send *trans-menu* :enabled nil)
(send *toolbar* :restore-toolbar)
(when *verbose* (print "DID SOME MENU STUFF"))
(setf *open-edit-here-directory* 
      (if *pro-version* *default-path* *user-dir-name*))
(setf *open-data-here-directory* *data-dir-name*)
(setf *open-import-here-directory* *default-path*)
(setf *desktop-datasheet* nil)
#+containers(enable-container *desktop-container*)
;(cond 
;  (*initial-datasheet*
;      (let ((rtdu *realtime-datasheet-update*))
;        (setf *realtime-datasheet-update* nil)
        (setf *desktop-datasheet* (new-data "hidden" t))
        (setf *datasheet* *desktop-datasheet*)
;        (setf *realtime-datasheet-update* rtdu)))
;  (t (setf *desktop-datasheet* *fake-datasheet*)
;     ))  
#+containers(disable-container)


#|_______________________________
 |
 | STEP B 15: Real-Time DataSheet Opening
 |_______________________________
 |#

(when *startup-verbose* (show-startup "STEP B 15: Real-Time DataSheet Opening"))


(when *verbose* (print "DID REAL-TIME-DATASHEET-UPDATE"))
(send *desktop-datasheet* :show-window)
(when *verbose* (print "AFTER DATASHEET SHOW-WINDOW"))
#+containers
(defmeth *desktop-container* :do-key (c m1 m2)
  (send *workmap* :do-key c m1 m2))
;MAKES ICONS LOCATE CORRECTLY WHEN WINDOW CLOSED
(SEND *WORKMAP* :SIZE 475 280)
(when *verbose* (print "BEFORE UNCOMPILABLE FUNCTIONS"))

(when (or *pro-version* *devel-mode*) 
      (set-vista-pro-version)
      (devel-mode t))
(send *workmap* :no-move t)
(send *desktop-datasheet* :no-move t)
(send *var-window* :no-move t)
(send *obs-window* :no-move t)
(send *varobs-obj* :no-move t)
(send *workmap* :has-h-scroll nil)
(send *workmap* :has-v-scroll nil)
(send *desktop-datasheet* :has-h-scroll nil)
(send *desktop-datasheet* :has-v-scroll nil)
(send *var-window* :has-v-scroll nil)
(send *obs-window* :has-v-scroll nil)

;fwy changed dec 16 2002
(unless *desktop-start-loc-size*
        (setf *desktop-start-loc-size* 
              (select *seven-values* (list 2 3 0 1)))) 
(send *desktop-container* :location 
        (third *seven-values*)   ; *desktop-start-loc-size*
        (fourth *seven-values*)); *desktop-start-loc-size*
(send *desktop-container* :size 
        (first *seven-values*)  ;third *desktop-start-loc-size*
        (second *seven-values*)); *desktop-start-loc-size*
;(apply #'send *desktop-container* :location 
;       (select *desktop-start-loc-size* '(0 1))) 
;(apply #'send *desktop-container* :size 
;       (select *desktop-start-loc-size* '(2 3)))
;fwy end change dec 16 2002

(setf *vista-help* (send menu-item-proto :new "Topics"))
(send *vista* :background-color t)
(send *toolbar* :change-num-tools-shown
      *num-toolbar-buts-shown-at-startup*)
(when *verbose* (format t "~%Updated Number of Toolbar Buttons"))
(send *vista* :frames-per-second *frames-per-second*)

#|
 | if first run and is pro-version (which depends on user-mode, admin-mode 
 | and directory structure) then set devel-mode to t. never change devel mode again
 |#     
             

(set-vista-distributor-mode)
(menus t)
(menus nil)
(menus t)
(make-version)
(send *listener* :frame-location 0 (- (fourth *desktop-start-loc-size*) 4))
(send *listener* :size (third *desktop-start-loc-size*) 64)
(send *listener* :no-move t)
(send *varobs-obj* :show-window)


#|_______________________________
 |
 | STEP B 16: READ PHASE 4 FILES
 |_______________________________
 |#


(when *startup-verbose* (show-startup "STEP B 16: Read Phase 4 Files"))

  (when (load (strcat *default-path* "update\\phase4.lsp") :if-does-not-exist nil)
        (setf *updated* t)
        (when *verbose* (format t "; Phase4 update completed")))

#|_______________________________
 |
 | STEP B 17: Locate and Size DeskTop
 |_______________________________
 |#


  (when *startup-verbose* (show-startup "STEP B 17: Locate and Size DeskTop"))
  (when *startup-verbose* (format t "; in final opening sequence of vista1.lsp"))
  (when *verbose* (FORMAT T "~5%READY FOR END GAME! :-)~5%"))
  (msw-write-profile-string "ViSta" "ViStaOp" "no" *ini-file*)
  (msw-write-profile-string "ViSta" "Starter"  nil *ini-file*)
  (msw-write-profile-string "ViSta" "Startup"  nil *ini-file*)


  (when *startup-verbose* (show-startup "STEP B 18: Starting opening sequence"))

  (setf logolocsize (combine (send *logo* :location) (send *logo* :size)))
  (startup-defs-vista-xlisp )

 ;(load-gui)

  (setf *realtime-datasheet-update* t)
  (setf *vista-startup* t)
  

  (send *desktop-container* :location 
        (third *seven-values*)   ; *desktop-start-loc-size*
        (fourth *seven-values*)); *desktop-start-loc-size*
  (send *desktop-container* :size 
        (first *seven-values*)  ;third *desktop-start-loc-size*
        (second *seven-values*)); *desktop-start-loc-size*
  
  ;(when (= *run-number* 1) 
  ;      (localize-seven-values)
  ;      ;(send *desktop-container* :make-desktop-container-default-layout)
  ;      )
  ;(send *vista* :desktop-size (select *seven-values* (list 0 1)))
  ;(send *vista* :workmap-proportion (select *seven-values* 4))
  ;(send *vista* :spreadplot-sizes (select *seven-values* (list 5 6)))
  
  (refresh-desktop) 

  (send *listener* :frame-location 0 (- (fourth *desktop-start-loc-size*) 4))
  (send *listener* :size (third *desktop-start-loc-size*) 54)
  (send *listener* :no-move t)
  (send *vista* :desktop-location (select *seven-values* (list 2 3)))
  (send *vista* :desktop-size (select *seven-values* '(0 1)))
  (apply #'send *desktop-container* :location (select *seven-values* (list 2 3)))

  (setf *desktop-datasheet* (new-data "hidden" t))

  (send *desktop-container* :size 
        (select *seven-values* 0)
        (select *seven-values* 1))
(when *startup-verbose* (show-startup "STEP B 19 MAKING DESKTOP"))
  (send *desktop-container* :make-desktop-container-resize)
  (send *desktop-container* :make-desktop-container-size)
 ; (setf *num-listener-lines* *default-num-listener-lines*)
 

#|_______________________________
 |
 | STEP B 17: Regenerate Final DeskTop Display Mode
 |_______________________________
 |#

  (when *startup-verbose* (show-startup "STEP B 20: Regenerate Final DeskTop Display Mode"))
  (when *maximized-listener?* (maximize-listener))
  (save-gui)
  (msw-write-profile-string "ViSta" "ViStaOp" "yes" *ini-file*)
  (setf *desk-up* nil)
  (setf *xlispstat-only* nil)
  (msw-write-profile-string "ViSta" "XLispOnly" "No" *ini-file*)
 
  (creation-time-functions)

  (cond 
    (*devel-mode*
     (setf *current-data-dir-name* *data-path*)
     (setf *examples-data-dir-name* *data-path*)
     )
    (t
     ;these definitions override developer-specific versions found elsewhere
     (defun refresh-vista () 
       (restart-vista))
   
     (defun restart-vista (&optional dir)
       (save-all-prefs)
       (if dir
           (system (strcat dir "vista.exe"))
           (system (strcat *default-path* "vista.exe")))
       (exit))

   (setf *current-data-dir-name* *user-path*)
   (setf *examples-data-dir-name* *user-path*)
   ))

#|_______________________________
 |
 | STEP B 18: Close Logo Window, If Open
 |_______________________________
 |#

  (when *startup-verbose* (show-startup "STEP B 21: Close Logo Window, If Open"))
	
 ; (when *hide-logo* (hidemainwindow))
 ; (unless *hide-logo*
 ;         (when *show-flying-logo* 
 ;               (send *logo* :disolve :direction 0 :close nil)
 ;               (setf *hide-logo* t))
 ;         (send *logo* :location 2000 2000)
 ;         )
  
  (setf *check-vist-init* t)
  (when *check-vist-init*
        (load "vistinit" :if-does-not-exist nil)
        (setf *check-vist-init* nil))
  
  (setf *vista-has-been-shown* nil)

  (if (and (boundp '*PREVIOUS-DATASHEET*) 
           *PREVIOUS-DATASHEET*)
      (send *PREVIOUS-DATASHEET* :remove)
      (setf *previous-datasheet* nil))

  (when *startup-verbose* (show-startup "STEP B 22: Create PopUp Menus"))
  (create-popup-menus)

  
  (when *startup-verbose* (show-startup "STEP B 23: Activate Windows"))
  (defmeth *listener* :active-window ()
    (send *listener* :pop-out t)
    (send *listener* :pop-out nil)
    (send *desktop-container* :active-window))

  (defmeth *workmap* :active-window ()
    (send self :top-most (send self :top-most))
    (send self :bottom-most (send self :bottom-most))
    (send *desktop-container* :active-window))

  (defmeth *listener* :active-window ()
    (let* ((list-loc (send *listener* :location))
           (list-siz (send *listener* :size)))
      ;next 3 statement hides the hide/show of *listener*, more or less
      (send *desktop-sheet* :title "Listener")
      (apply #'send *desktop-sheet* :location list-loc)
      (send *desktop-sheet* :top-most t)
      (send *desktop-sheet* :bottom-most nil)
      (send *listener* :location 0 2000)
      (send *listener* :size 0 0)
      ;next 2 statements cause cursor to be activated in *listener*
      (send *listener* :hide-window)
      (send *listener* :show-window)
      (apply #'send *listener* :size list-siz)
      (apply #'send *listener* :location list-loc)
      
      (send *desktop-sheet* :top-most t)
      (send *desktop-sheet* :bottom-most nil)
      ;next 3 uncover the desktop
      (send *desktop-sheet* :bottom-most t)
      (send *desktop-sheet* :top-most nil)
      (send *desktop-sheet* :location 2000 2000)
      (send *desktop-container* :active-window)))

  (defmeth *selector* :active-window ()
    (send self :top-most (send self :top-most))
    (send self :bottom-most (send self :bottom-most))
    (send *desktop-container* :active-window))

;;;
;;; (11) FINAL OPENING SEQUENCE
;;;      Prepare *WORKMAP* DO-IDLE to defer opening of gui until
;;;      all file processing is finished.
;;;      When finally idle, check on dde-data from excel or elswhere
;;;      Read it and do instructions of dde-data is present.
;;;      Then, if havn't shown ViSta and should, do so.
;;;      Stop
;;;

  
  (setf *vista-startup-error* nil)
  (setf error-return-flag nil)
  (when *startup-verbose* (show-startup (format nil "PART B:    END PART B - Exiting Create-ViSta ~a" (if *vista-startup-error* "Abnormally" "Normally"))))
  t));end of let* and of create-vista function
